<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WP_AIW_Plugin {
	private static $instance = null;

	public static function instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	private function __construct() {
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-settings.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-llm-client.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-rewriter.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-admin.php';
		require_once WP_AIW_DIR . 'includes/class-yqs-saas-announcements-widget.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-url-fetcher.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-writer.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-writer-admin.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-writer-metabox.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-image-client-openai-compatible.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-image-client.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-image-client-gemini.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-image-client-zhipu.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-image-generator.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-image-admin.php';
		require_once WP_AIW_DIR . 'includes/class-wp-aiw-featured-batch.php';

		WP_AIW_Settings::instance();
		WP_AIW_Admin::instance();
		WP_AIW_Writer_Admin::instance();
		WP_AIW_Writer_Metabox::instance();
		WP_AIW_Image_Admin::instance();

		YQS_SaaS_Announcements_Widget::instance(
			array(
				'ajax_action' => 'wp_aiw_saas_announcements_widget',
				'nonce_action' => 'wp_aiw_nonce',
				'capability' => 'manage_options',
				'user_agent' => 'WP-AIW-Writer/' . ( defined( 'WP_AIW_VERSION' ) ? WP_AIW_VERSION : 'dev' ),
				'limit' => 5,
				'ttl' => 10 * MINUTE_IN_SECONDS,
				'cache_prefix' => 'wp_aiw_saas_ann_widget_',
			)
		);
	}
}
