<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WP_AIW_Image_Client_Zhipu {
	/**
	 * Zhipu GLM-Image images/generations call.
	 * Response example:
	 * {
	 *   "created": 123,
	 *   "data": [{"url": "https://..."}]
	 * }
	 *
	 * @return array{ok:bool, url?:string, error?:string, raw?:mixed}
	 */
	public function generate_image_url( $base_url, $api_key, $model, $prompt, $size = '1280x1280', $timeout = 180 ) {
		$base_url = is_string( $base_url ) ? rtrim( trim( $base_url ), '/' ) : '';
		$api_key  = is_string( $api_key ) ? trim( $api_key ) : '';
		$model    = is_string( $model ) ? trim( $model ) : '';
		$prompt   = is_string( $prompt ) ? trim( $prompt ) : '';
		$size     = is_string( $size ) ? trim( $size ) : '1280x1280';

		if ( $base_url === '' ) {
			return array( 'ok' => false, 'error' => 'image_base_url 未配置（智谱：例如 https://open.bigmodel.cn/api/paas/v4）' );
		}
		if ( $api_key === '' ) {
			return array( 'ok' => false, 'error' => 'image_api_key 未配置' );
		}
		if ( $model === '' ) {
			return array( 'ok' => false, 'error' => 'image_model 未配置（智谱：例如 glm-image）' );
		}
		if ( $prompt === '' ) {
			return array( 'ok' => false, 'error' => 'prompt 不能为空' );
		}

		$endpoint = $base_url . '/images/generations';

		$body = array(
			'model' => $model,
			'prompt' => $prompt,
			'size' => $size,
		);

		$args = array(
			'timeout' => (int) $timeout,
			'redirection' => 3,
			'reject_unsafe_urls' => true,
			'headers' => array(
				'Content-Type' => 'application/json; charset=utf-8',
				'Authorization' => 'Bearer ' . $api_key,
			),
			'body' => wp_json_encode( $body ),
		);

		$response = wp_remote_post( $endpoint, $args );
		if ( is_wp_error( $response ) ) {
			return array( 'ok' => false, 'error' => $response->get_error_message(), 'raw' => $response );
		}

		$code = (int) wp_remote_retrieve_response_code( $response );
		$raw_body = wp_remote_retrieve_body( $response );
		$data = json_decode( $raw_body, true );

		if ( $code < 200 || $code >= 300 ) {
			$error = '智谱 Image 请求失败（HTTP ' . $code . '）';
			if ( is_array( $data ) && isset( $data['error']['message'] ) ) {
				$error .= ': ' . (string) $data['error']['message'];
			}
			return array( 'ok' => false, 'error' => $error, 'raw' => $raw_body );
		}

		if ( ! is_array( $data ) ) {
			return array( 'ok' => false, 'error' => '智谱 Image 返回不是有效 JSON', 'raw' => $raw_body );
		}

		$url = '';
		if ( isset( $data['data'][0]['url'] ) ) {
			$url = (string) $data['data'][0]['url'];
		}
		$url = trim( $url );
		if ( $url === '' ) {
			return array( 'ok' => false, 'error' => '智谱 Image 返回缺少 data[0].url', 'raw' => $data );
		}

		return array( 'ok' => true, 'url' => $url, 'raw' => $data );
	}
}
