<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class WP_AIW_Featured_Batch {
	/**
	 * Find next post id within criteria.
	 *
	 * @param array $criteria
	 * @return int
	 */
	public function find_next_post_id( $criteria = array() ) {
		$criteria = is_array( $criteria ) ? $criteria : array();
		$category_id = isset( $criteria['category_id'] ) ? (int) $criteria['category_id'] : 0;
		$tag_id      = isset( $criteria['tag_id'] ) ? (int) $criteria['tag_id'] : 0;
		$date_after  = isset( $criteria['date_after'] ) ? (string) $criteria['date_after'] : '';
		$date_before = isset( $criteria['date_before'] ) ? (string) $criteria['date_before'] : '';
		$author_id   = isset( $criteria['author_id'] ) ? (int) $criteria['author_id'] : 0;
		$include_children = true;
		if ( isset( $criteria['category_include_children'] ) ) {
			$include_children = (bool) $criteria['category_include_children'];
		}
		$order_mode  = isset( $criteria['order_mode'] ) ? (string) $criteria['order_mode'] : 'oldest';
		$mode        = isset( $criteria['mode'] ) ? (string) $criteria['mode'] : 'missing_only';

		$exclude_ids = array();
		if ( isset( $criteria['exclude_ids'] ) ) {
			$raw = $criteria['exclude_ids'];
			if ( is_string( $raw ) ) {
				$parts = preg_split( '/[^0-9]+/', $raw );
				if ( is_array( $parts ) ) {
					foreach ( $parts as $p ) {
						$id = (int) $p;
						if ( $id > 0 ) {
							$exclude_ids[] = $id;
						}
					}
				}
			} elseif ( is_array( $raw ) ) {
				foreach ( $raw as $p ) {
					$id = (int) $p;
					if ( $id > 0 ) {
						$exclude_ids[] = $id;
					}
				}
			}
			$exclude_ids = array_values( array_unique( $exclude_ids ) );
			if ( count( $exclude_ids ) > 500 ) {
				$exclude_ids = array_slice( $exclude_ids, 0, 500 );
			}
		}

		$orderby = 'ID';
		$order   = 'ASC';
		if ( $order_mode === 'modified_desc' ) {
			$orderby = 'modified';
			$order   = 'DESC';
		}

		$args = array(
			'post_type' => 'post',
			'post_status' => 'publish',
			'posts_per_page' => 1,
			'orderby' => $orderby,
			'order' => $order,
			'fields' => 'ids',
		);

		if ( ! empty( $exclude_ids ) ) {
			$args['post__not_in'] = $exclude_ids;
		}

		if ( $author_id > 0 ) {
			$args['author'] = $author_id;
		}

		$tax_query = array();
		if ( $category_id > 0 ) {
			$tax_query[] = array(
				'taxonomy' => 'category',
				'field' => 'term_id',
				'terms' => array( $category_id ),
				'include_children' => $include_children,
			);
		}
		if ( $tag_id > 0 ) {
			$tax_query[] = array(
				'taxonomy' => 'post_tag',
				'field' => 'term_id',
				'terms' => array( $tag_id ),
			);
		}
		if ( ! empty( $tax_query ) ) {
			if ( count( $tax_query ) > 1 ) {
				$tax_query = array_merge( array( 'relation' => 'AND' ), $tax_query );
			}
			$args['tax_query'] = $tax_query;
		}

		if ( $date_after !== '' || $date_before !== '' ) {
			$date_clause = array( 'inclusive' => true );
			if ( $date_after !== '' ) {
				$date_clause['after'] = $date_after;
			}
			if ( $date_before !== '' ) {
				$date_clause['before'] = $date_before;
			}
			$args['date_query'] = array( $date_clause );
		}

		// missing_only: only pick posts without _thumbnail_id.
		if ( $mode !== 'regenerate_all' ) {
			$args['meta_query'] = array(
				'relation' => 'OR',
				array(
					'key' => '_thumbnail_id',
					'compare' => 'NOT EXISTS',
				),
				array(
					'key' => '_thumbnail_id',
					'value' => '0',
					'compare' => '=',
				),
				array(
					'key' => '_thumbnail_id',
					'value' => '',
					'compare' => '=',
				),
			);
		}

		$q = new WP_Query( $args );
		if ( ! $q->have_posts() ) {
			return 0;
		}

		$ids = $q->posts;
		return ! empty( $ids[0] ) ? (int) $ids[0] : 0;
	}
}
