(function(){'use strict';function $(id){return document.getElementById(id);}
function escapeHtml(str){return String(str).replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&#039;');}
function logLine(msg){var el=$('wp-aiw-writer-log');if(!el)return;var div=document.createElement('div');div.textContent=msg;el.appendChild(div);el.scrollTop=el.scrollHeight;}
function setStatus(msg){var el=$('wp-aiw-writer-status');if(!el)return;el.textContent=msg;}
function setResult(html){var el=$('wp-aiw-writer-result');if(!el)return;el.innerHTML=html;}
async function postForm(payload){var body=new URLSearchParams(payload);var resp=await fetch(wpAiwWriter.ajaxUrl,{method:'POST',credentials:'same-origin',headers:{'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'},body:body.toString(),});var data;try{data=await resp.json();}catch(e){throw new Error('响应不是 JSON');}
if(!data||data.success!==true){var msg=(data&&data.data&&data.data.message)?data.data.message:'请求失败';var err=new Error(msg);err.payload=data;throw err;}
return data.data;}
function bind(){var btn=$('wp-aiw-writer-generate');if(!btn)return;btn.addEventListener('click',async function(){var title=($('wp-aiw-writer-title')&&$('wp-aiw-writer-title').value)?$('wp-aiw-writer-title').value.trim():'';var requirements=($('wp-aiw-writer-req')&&$('wp-aiw-writer-req').value)?$('wp-aiw-writer-req').value.trim():'';var urls=($('wp-aiw-writer-urls')&&$('wp-aiw-writer-urls').value)?$('wp-aiw-writer-urls').value.trim():'';var referenceText=($('wp-aiw-writer-ref')&&$('wp-aiw-writer-ref').value)?$('wp-aiw-writer-ref').value.trim():'';var language=($('wp-aiw-writer-lang')&&$('wp-aiw-writer-lang').value)?$('wp-aiw-writer-lang').value:'zh';var debug=$('wp-aiw-writer-debug')&&$('wp-aiw-writer-debug').checked?'1':'';var autoFeatured=$('wp-aiw-writer-auto-featured')&&$('wp-aiw-writer-auto-featured').checked;$('wp-aiw-writer-log').innerHTML='';setResult('');if(!title){setStatus('请先填写标题');return;}
btn.disabled=true;setStatus('生成中…');logLine('开始生成草稿…');try{var result=await postForm({action:'wp_aiw_writer_generate_draft',nonce:wpAiwWriter.nonce,title:title,requirements:requirements,urls:urls,referenceText:referenceText,language:language,debug:debug,});logLine('草稿已创建：ID='+result.postId);if(result.tags&&result.tags.length){logLine('tags 已返回并插入（数量：'+result.tags.length+'）');}else{logLine('tags 未返回或为空');}
var imageNote='';if(autoFeatured){if(!window.wpAiwFeaturedImage||!window.wpAiwFeaturedImage.runOptional){imageNote='跳过（缺少 featured-image 脚本）';logLine('特色图：'+imageNote);}else{logLine('特色图：开始生成并设置…');var imgOpt=await window.wpAiwFeaturedImage.runOptional({enabled:true,flags:{imageEnabled:wpAiwWriter.imageEnabled,},ajaxUrl:wpAiwWriter.ajaxUrl,nonce:wpAiwWriter.nonce,postId:result.postId,title:result.title||title,language:language,debug:debug==='1',});imageNote=imgOpt&&imgOpt.message?imgOpt.message:'';if(imgOpt&&imgOpt.status==='done'){logLine('特色图：'+imageNote);}else if(imgOpt&&imgOpt.status==='skipped'){logLine('特色图：'+imageNote);}else if(imgOpt&&imgOpt.status==='failed'){logLine('特色图：'+imageNote+'（不影响草稿）');}else{logLine('特色图：失败（未知错误）（不影响草稿）');}}}
var linkHtml='';if(result.editUrl){linkHtml='<p><a href="'+escapeHtml(result.editUrl)+'" target="_blank" rel="noopener">打开草稿编辑页</a></p>';}
var imageHtml='';if(autoFeatured){imageHtml='<p><strong>特色图：</strong>'+escapeHtml(imageNote||'')+'</p>';}
var debugHtml='';if(result.debug){debugHtml='<details style="margin-top:8px;"><summary>调试信息</summary><pre style="white-space:pre-wrap;">'+escapeHtml(JSON.stringify(result.debug,null,2))+'</pre></details>';}
setResult('<div style="padding:12px;background:#fff;border:1px solid #dcdcde;border-radius:6px;">'+'<p><strong>标题：</strong>'+escapeHtml(result.title||title)+'</p>'+
linkHtml+
imageHtml+
debugHtml+'</div>');setStatus('完成');}catch(e){setStatus('失败');logLine('错误：'+(e&&e.message?e.message:String(e)));if(e&&e.payload&&e.payload.data&&e.payload.data.debug){logLine('调试：'+JSON.stringify(e.payload.data.debug));}}finally{btn.disabled=false;}});}
if(document.readyState==='loading'){document.addEventListener('DOMContentLoaded',bind);}else{bind();}})();