(function(){'use strict';function $(id){return document.getElementById(id);}
function escapeHtml(str){return String(str).replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&#039;');}
function logLine(msg){var el=$('wp-aiw-writer-mb-log');if(!el)return;var div=document.createElement('div');div.textContent=msg;el.appendChild(div);el.scrollTop=el.scrollHeight;}
function setStatus(msg){var el=$('wp-aiw-writer-mb-status');if(!el)return;el.textContent=msg;}
function setImageStatus(msg){var el=$('wp-aiw-writer-mb-image-status');if(!el)return;el.textContent=msg;}
function setResult(html){var el=$('wp-aiw-writer-mb-result');if(!el)return;el.innerHTML=html;}
function truncateForLog(str,maxLen){str=String(str||'');maxLen=parseInt(maxLen,10);if(!maxLen||isNaN(maxLen)||maxLen<100)maxLen=800;if(str.length<=maxLen)return str;return str.slice(0,maxLen)+'…（已截断，共 '+str.length+' 字符）';}
function isBlockEditor(){try{if(!document||!document.body||!document.body.classList)return false;if(!document.body.classList.contains('block-editor-page'))return false;if(!window.wp||!window.wp.data||typeof window.wp.data.select!=='function')return false;var editorSel=window.wp.data.select('core/editor');return!!(editorSel&&typeof editorSel.getEditedPostAttribute==='function');}catch(e){return false;}}
function getEditorTitle(){try{if(isBlockEditor()){var editorSel=window.wp.data.select('core/editor');if(editorSel&&typeof editorSel.getEditedPostAttribute==='function'){var t2=editorSel.getEditedPostAttribute('title');if(typeof t2==='string'&&t2.trim())return t2.trim();}}}catch(e0){}
var titleEl=document.getElementById('title');if(titleEl&&titleEl.value)return titleEl.value.trim();return'';}
function getEditorContent(){try{if(isBlockEditor()){var editorSel=window.wp.data.select('core/editor');if(editorSel&&typeof editorSel.getEditedPostAttribute==='function'){var c2=editorSel.getEditedPostAttribute('content');if(typeof c2==='string'){return c2;}}}}catch(e0){}
try{if(window.tinyMCE&&window.tinyMCE.get&&window.tinyMCE.get('content')){var ed=window.tinyMCE.get('content');if(ed&&!ed.isHidden()){return ed.getContent({format:'html'})||'';}}}catch(e){}
var textarea=document.getElementById('content');if(textarea&&typeof textarea.value==='string'){return textarea.value;}
return'';}
function setEditorContent(nextHtml){try{if(isBlockEditor()&&window.wp&&window.wp.data&&typeof window.wp.data.dispatch==='function'){var editorDis=window.wp.data.dispatch('core/editor');if(editorDis&&typeof editorDis.editPost==='function'){editorDis.editPost({content:String(nextHtml||'')});}
try{if(window.wp&&window.wp.blocks&&typeof window.wp.blocks.parse==='function'){var blockDis=window.wp.data.dispatch('core/block-editor');if(blockDis&&typeof blockDis.resetBlocks==='function'){blockDis.resetBlocks(window.wp.blocks.parse(String(nextHtml||'')));}}}catch(eB1){}}}catch(e0){}
var textarea=document.getElementById('content');if(textarea){textarea.value=nextHtml;}
try{if(window.tinyMCE&&window.tinyMCE.get&&window.tinyMCE.get('content')){var ed=window.tinyMCE.get('content');if(ed&&!ed.isHidden()){ed.setContent(nextHtml);try{if(typeof ed.fire==='function')ed.fire('change');if(typeof ed.save==='function')ed.save();}catch(eSync){}}}}catch(e){}}
function setEditorTitle(nextTitle){try{if(isBlockEditor()&&window.wp&&window.wp.data&&typeof window.wp.data.dispatch==='function'){var editorDis=window.wp.data.dispatch('core/editor');if(editorDis&&typeof editorDis.editPost==='function'){editorDis.editPost({title:String(nextTitle||'')});}}}catch(e0){}
var titleEl=document.getElementById('title');if(titleEl){titleEl.value=nextTitle;}}
function getClassicTagInputValue(){var taxInput=document.getElementById('tax-input-post_tag');if(!taxInput||typeof taxInput.value!=='string')return'';return taxInput.value;}
function getGutenbergTagIds(){try{if(!isBlockEditor()||!window.wp||!window.wp.data||typeof window.wp.data.select!=='function'){return[];}
var editorSel=window.wp.data.select('core/editor');if(!editorSel||typeof editorSel.getEditedPostAttribute!=='function'){return[];}
var ids=editorSel.getEditedPostAttribute('tags')||[];if(!Array.isArray(ids))return[];return ids.map(function(x){return parseInt(x,10)||0;}).filter(function(x){return x>0;});}catch(e){return[];}}
function sortNumberArray(arr){if(!Array.isArray(arr))return[];return arr.slice().sort(function(a,b){return(a||0)-(b||0);});}
function sameNumberArray(a,b){a=sortNumberArray(a);b=sortNumberArray(b);if(a.length!==b.length)return false;for(var i=0;i<a.length;i++){if((a[i]||0)!==(b[i]||0))return false;}
return true;}
function uniqTags(arr){if(!Array.isArray(arr))return[];var out=[];var seen={};for(var i=0;i<arr.length;i++){var t=String(arr[i]||'').trim();if(!t)continue;var key=t.toLowerCase();if(seen[key])continue;seen[key]=true;out.push(t);}
return out;}
function parseCsvTags(str){str=String(str||'');if(!str.trim())return[];return str.split(/[，,]/).map(function(s){return String(s||'').trim();}).filter(function(s){return!!s;});}
function applyTagsToClassicEditorOverwrite(tags){tags=uniqTags(tags);var postbox=document.getElementById('tagsdiv-post_tag');var tagsDiv=document.getElementById('post_tag')||(postbox?postbox.querySelector('.tagsdiv'):null);var taxInput=document.getElementById('tax-input-post_tag');if(taxInput){var mergedStr=tags.join(',');try{if(window.tagBox&&typeof window.tagBox.clean==='function'){mergedStr=window.tagBox.clean(mergedStr);}}catch(e1){}
taxInput.value=mergedStr;try{if(window.tagBox&&typeof window.tagBox.quickClicks==='function'&&tagsDiv){window.tagBox.quickClicks(tagsDiv);}}catch(e2){}
return{ok:true,applied:tags.length};}
return{ok:false,applied:0};}
function applyTagsToClassicEditorMerge(tags){tags=uniqTags(tags);var taxInput=document.getElementById('tax-input-post_tag');if(!taxInput){return{ok:false,applied:0};}
var postbox=document.getElementById('tagsdiv-post_tag');var tagsDiv=document.getElementById('post_tag')||(postbox?postbox.querySelector('.tagsdiv'):null);var existing=parseCsvTags(taxInput.value||'');var merged=uniqTags(existing.concat(tags));var mergedStr=merged.join(',');try{if(window.tagBox&&typeof window.tagBox.clean==='function'){mergedStr=window.tagBox.clean(mergedStr);}}catch(e1){}
taxInput.value=mergedStr;try{if(window.tagBox&&typeof window.tagBox.quickClicks==='function'&&tagsDiv){window.tagBox.quickClicks(tagsDiv);}}catch(e2){}
return{ok:true,applied:merged.length,added:uniqTags(tags).length};}
async function applyTagsToBlockEditorOverwrite(tags){tags=uniqTags(tags);if(!isBlockEditor()||!window.wp||!window.wp.data||!window.wp.apiFetch){return{ok:false,applied:0,reason:'no_wp_data'};}
var select=window.wp.data.select;var dispatch=window.wp.data.dispatch;if(typeof select!=='function'||typeof dispatch!=='function'){return{ok:false,applied:0,reason:'no_select_dispatch'};}
var editorSel=select('core/editor');var editorDis=dispatch('core/editor');if(!editorSel||!editorDis||typeof editorDis.editPost!=='function'){return{ok:false,applied:0,reason:'no_core_editor'};}
async function getOrCreateTagId(tagName){tagName=String(tagName||'').trim();if(!tagName)return 0;var found=await window.wp.apiFetch({path:'/wp/v2/tags?search='+encodeURIComponent(tagName)+'&per_page=100',});var id=0;if(Array.isArray(found)){for(var i=0;i<found.length;i++){if(found[i]&&found[i].name&&String(found[i].name).toLowerCase()===tagName.toLowerCase()){id=parseInt(found[i].id,10)||0;break;}}
if(!id&&found[0]&&found[0].id){id=parseInt(found[0].id,10)||0;}}
if(id>0)return id;var created=await window.wp.apiFetch({path:'/wp/v2/tags',method:'POST',data:{name:tagName},});if(created&&created.id)return parseInt(created.id,10)||0;return 0;}
var ids=[];for(var j=0;j<tags.length;j++){try{var tid=await getOrCreateTagId(tags[j]);if(tid>0)ids.push(tid);}catch(e){}}
editorDis.editPost({tags:ids});return{ok:true,applied:ids.length};}
async function applyTagsToBlockEditorMerge(tags){tags=uniqTags(tags);if(!isBlockEditor()||!window.wp||!window.wp.data||!window.wp.apiFetch){return{ok:false,applied:0,reason:'no_wp_data'};}
var select=window.wp.data.select;var dispatch=window.wp.data.dispatch;if(typeof select!=='function'||typeof dispatch!=='function'){return{ok:false,applied:0,reason:'no_select_dispatch'};}
var editorSel=select('core/editor');var editorDis=dispatch('core/editor');if(!editorSel||!editorDis||typeof editorDis.editPost!=='function'){return{ok:false,applied:0,reason:'no_core_editor'};}
async function getOrCreateTagId(tagName){tagName=String(tagName||'').trim();if(!tagName)return 0;var found=await window.wp.apiFetch({path:'/wp/v2/tags?search='+encodeURIComponent(tagName)+'&per_page=100',});var id=0;if(Array.isArray(found)){for(var i=0;i<found.length;i++){if(found[i]&&found[i].name&&String(found[i].name).toLowerCase()===tagName.toLowerCase()){id=parseInt(found[i].id,10)||0;break;}}
if(!id&&found[0]&&found[0].id){id=parseInt(found[0].id,10)||0;}}
if(id>0)return id;var created=await window.wp.apiFetch({path:'/wp/v2/tags',method:'POST',data:{name:tagName},});if(created&&created.id)return parseInt(created.id,10)||0;return 0;}
var existingIds=[];try{existingIds=editorSel.getEditedPostAttribute?(editorSel.getEditedPostAttribute('tags')||[]):[];}catch(e0){existingIds=[];}
if(!Array.isArray(existingIds))existingIds=[];var ids=[];var seen={};for(var k=0;k<existingIds.length;k++){var exId=parseInt(existingIds[k],10)||0;if(exId>0&&!seen[String(exId)]){seen[String(exId)]=true;ids.push(exId);}}
for(var j=0;j<tags.length;j++){try{var tid=await getOrCreateTagId(tags[j]);if(tid>0&&!seen[String(tid)]){seen[String(tid)]=true;ids.push(tid);}}catch(e){}}
editorDis.editPost({tags:ids});return{ok:true,applied:ids.length};}
async function postForm(payload){var body=new URLSearchParams(payload);var resp=await fetch(wpAiwWriterMetabox.ajaxUrl,{method:'POST',credentials:'same-origin',headers:{'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'},body:body.toString(),});var data;try{data=await resp.json();}catch(e){throw new Error('响应不是 JSON');}
if(!data||data.success!==true){var msg=(data&&data.data&&data.data.message)?data.data.message:'请求失败';var err=new Error(msg);err.payload=data;throw err;}
return data.data;}
var imageState={b64:'',url:'',mime:'image/png',promptUsed:'',insertedCount:0,attachmentId:0,};function getImageCfg(){var cfg=(window.wpAiwWriterMetabox&&window.wpAiwWriterMetabox.image)?window.wpAiwWriterMetabox.image:{};return{provider:cfg.provider||'gemini_generatecontent',enabled:!!cfg.enabled,defaultSize:cfg.defaultSize||'1024x1024',maxPerPost:(typeof cfg.maxPerPost==='number')?cfg.maxPerPost:parseInt(cfg.maxPerPost||'3',10),};}
function showImagePreview(dataUrl){var wrap=$('wp-aiw-writer-mb-image-preview');var img=$('wp-aiw-writer-mb-image-preview-img');if(!wrap||!img)return;img.src=dataUrl;wrap.style.display='block';}
function insertHtmlIntoEditor(html,mode){mode=mode||'append';if(mode==='cursor'){try{if(window.tinyMCE&&window.tinyMCE.get&&window.tinyMCE.get('content')){var ed=window.tinyMCE.get('content');if(ed&&!ed.isHidden()){ed.focus();ed.execCommand('mceInsertContent',false,html);var taSync=document.getElementById('content');if(taSync&&typeof taSync.value==='string'){taSync.value=ed.getContent({format:'html'})||taSync.value;}
return;}}}catch(e){}
var textarea=document.getElementById('content');if(textarea&&typeof textarea.value==='string'&&typeof textarea.selectionStart==='number'&&typeof textarea.selectionEnd==='number'){var start=textarea.selectionStart;var end=textarea.selectionEnd;var val=textarea.value;textarea.value=val.slice(0,start)+html+val.slice(end);var caret=start+html.length;textarea.selectionStart=caret;textarea.selectionEnd=caret;textarea.focus();return;}}
var existing=getEditorContent();var next='';if(mode==='prepend'){next=html+(existing?"\n\n"+existing:'');}else{next=(existing?existing+"\n\n":'')+html;}
setEditorContent(next);}
function buildImgHtml(src,alt){alt=alt?String(alt):'';return'<p><img src="'+escapeHtml(src)+'" alt="'+escapeHtml(alt)+'" /></p>';}
function stripGutenbergBlockComments(html){html=String(html||'');return html.replace(/<!--\s*\/?wp:[\s\S]*?-->/g,'');}
function bind(){var btn=$('wp-aiw-writer-mb-generate');if(!btn)return;var modeSel=$('wp-aiw-writer-mb-mode');var writeOptions=$('wp-aiw-writer-mb-write-options');var rewriteOptions=$('wp-aiw-writer-mb-rewrite-options');var btnLabelIdle='生成并写入';var btnLocked=false;var baseline=null;var baselineReady=false;var blockUnsubscribe=null;function readSnapshot(){return{title:String(getEditorTitle()||''),content:String(getEditorContent()||''),classicTags:String(getClassicTagInputValue()||''),tagIds:getGutenbergTagIds(),};}
function captureBaselineLater(){baselineReady=false;setTimeout(function(){baseline=readSnapshot();baselineReady=true;},250);}
function hasEditorChangedSinceBaseline(){if(!baselineReady||!baseline)return false;var cur=readSnapshot();if(cur.title!==baseline.title)return true;if(cur.content!==baseline.content)return true;if(cur.classicTags!==baseline.classicTags)return true;if(!sameNumberArray(cur.tagIds,baseline.tagIds))return true;return false;}
function lockButton(text){btnLocked=true;btn.disabled=true;if(text)btn.textContent=text;captureBaselineLater();}
function unlockButton(){btnLocked=false;btn.disabled=false;btn.textContent=btnLabelIdle;setStatus('');}
function refreshModeUi(){var mode=modeSel?modeSel.value:'write_current';if(writeOptions){writeOptions.style.display=(mode==='write_current')?'block':'none';}
if(rewriteOptions){rewriteOptions.style.display=(mode==='rewrite_current')?'block':'none';}
btnLabelIdle=(mode==='rewrite_current')?'重写并写入':'生成并写入';if(!btnLocked){btn.textContent=btnLabelIdle;}}
if(modeSel){modeSel.addEventListener('change',function(){refreshModeUi();unlockButton();});}
refreshModeUi();function bindResetOnChange(id,evt){var el=$(id);if(!el)return;el.addEventListener(evt||'change',function(){if(btnLocked)unlockButton();});}
bindResetOnChange('wp-aiw-writer-mb-write-mode','change');bindResetOnChange('wp-aiw-writer-mb-write-title','change');bindResetOnChange('wp-aiw-writer-mb-rewrite-title','change');bindResetOnChange('wp-aiw-writer-mb-title','input');bindResetOnChange('wp-aiw-writer-mb-req','input');bindResetOnChange('wp-aiw-writer-mb-urls','input');bindResetOnChange('wp-aiw-writer-mb-ref','input');bindResetOnChange('wp-aiw-writer-mb-lang','change');bindResetOnChange('wp-aiw-writer-mb-debug','change');try{var contentEl=document.getElementById('content');if(contentEl){contentEl.addEventListener('input',function(){if(btnLocked&&hasEditorChangedSinceBaseline())unlockButton();});}}catch(eC0){}
try{if(window.tinyMCE&&window.tinyMCE.on){window.tinyMCE.on('AddEditor',function(ev){try{var ed=ev&&ev.editor?ev.editor:null;if(!ed)return;ed.on('change keyup',function(){if(btnLocked&&hasEditorChangedSinceBaseline())unlockButton();});}catch(eC2){}});}}catch(eC1){}
try{if(isBlockEditor()&&window.wp&&window.wp.data&&typeof window.wp.data.subscribe==='function'){var prevSnap=null;blockUnsubscribe=window.wp.data.subscribe(function(){if(!btnLocked)return;if(!baselineReady)return;var cur=readSnapshot();if(prevSnap&&cur.title===prevSnap.title&&cur.content===prevSnap.content&&cur.classicTags===prevSnap.classicTags&&sameNumberArray(cur.tagIds,prevSnap.tagIds)){return;}
prevSnap=cur;if(hasEditorChangedSinceBaseline()){unlockButton();}});}}catch(eB0){blockUnsubscribe=null;}
var t=$('wp-aiw-writer-mb-title');if(t&&!t.value){t.value=getEditorTitle();}
btn.addEventListener('click',async function(){var title=($('wp-aiw-writer-mb-title')&&$('wp-aiw-writer-mb-title').value)?$('wp-aiw-writer-mb-title').value.trim():'';if(!title)title=getEditorTitle();var requirements=($('wp-aiw-writer-mb-req')&&$('wp-aiw-writer-mb-req').value)?$('wp-aiw-writer-mb-req').value.trim():'';var urls=($('wp-aiw-writer-mb-urls')&&$('wp-aiw-writer-mb-urls').value)?$('wp-aiw-writer-mb-urls').value.trim():'';var referenceText=($('wp-aiw-writer-mb-ref')&&$('wp-aiw-writer-mb-ref').value)?$('wp-aiw-writer-mb-ref').value.trim():'';var language=($('wp-aiw-writer-mb-lang')&&$('wp-aiw-writer-mb-lang').value)?$('wp-aiw-writer-mb-lang').value:'zh';var debug=$('wp-aiw-writer-mb-debug')&&$('wp-aiw-writer-mb-debug').checked?'1':'';var mode=(modeSel&&modeSel.value)?modeSel.value:'write_current';var writeMode=($('wp-aiw-writer-mb-write-mode')&&$('wp-aiw-writer-mb-write-mode').value)?$('wp-aiw-writer-mb-write-mode').value:'overwrite';var writeTitle=$('wp-aiw-writer-mb-write-title')&&$('wp-aiw-writer-mb-write-title').checked;var rewriteTitle=$('wp-aiw-writer-mb-rewrite-title')&&$('wp-aiw-writer-mb-rewrite-title').checked;$('wp-aiw-writer-mb-log').innerHTML='';setResult('');if(!title){setStatus('请先填写标题');return;}
btn.disabled=true;setStatus(mode==='rewrite_current'?'重写中…':'生成中…');btn.textContent=(mode==='rewrite_current')?'重写中…':'生成中…';logLine(mode==='rewrite_current'?'开始重写当前文章（优化）…':'开始生成内容并写入当前文章…');try{if(mode==='write_current'){var gen=await postForm({action:'wp_aiw_writer_generate_content',nonce:wpAiwWriterMetabox.nonce,title:title,requirements:requirements,urls:urls,referenceText:referenceText,language:language,debug:debug,});var existing=getEditorContent();var next=gen.contentHtml||'';if(!next){throw new Error('返回内容为空（content_html）');}
if(writeMode==='append'&&existing){next=existing+"\n\n"+next;}
setEditorContent(next);if(writeTitle&&gen.title){setEditorTitle(gen.title);}
var tagResW=null;try{tagResW=applyTagsToClassicEditorMerge(gen.tags||[]);if(!tagResW||!tagResW.ok){tagResW=await applyTagsToBlockEditorMerge(gen.tags||[]);}}catch(eTW){tagResW=tagResW;}
if(tagResW&&tagResW.ok){logLine('tags 已同步到当前文章（合并写入，模型返回数量：'+((gen.tags&&gen.tags.length)?gen.tags.length:0)+'）');}else{logLine('tags 已返回，但未能自动同步到编辑器 UI');}
logLine('已写入当前文章编辑器（未保存）');var debugHtml2='';if(gen.debug){debugHtml2='<details style="margin-top:6px;"><summary>调试信息</summary><pre style="white-space:pre-wrap;">'+escapeHtml(JSON.stringify(gen.debug,null,2))+'</pre></details>';}
setResult('<div style="padding:8px;background:#fff;border:1px solid #dcdcde;border-radius:4px;">'+'<p style="margin:0 0 6px 0;"><strong>已写入当前文章</strong>（请记得保存/更新）</p>'+'<p style="margin:0;"><strong>标题：</strong>'+escapeHtml(gen.title||title)+'</p>'+
debugHtml2+'</div>');setStatus('成功（未保存）');lockButton('成功（未保存）');}else if(mode==='rewrite_current'){var postId=($('wp-aiw-writer-mb-post-id')&&$('wp-aiw-writer-mb-post-id').value)?parseInt($('wp-aiw-writer-mb-post-id').value,10):0;if(!postId||postId<=0){throw new Error('postId 无效（请刷新页面重试）');}
var curTitle=getEditorTitle()||title;var curContent=getEditorContent()||'';var curContentForModel=stripGutenbergBlockComments(curContent);if(curContentForModel!==curContent){logLine('已剥离 Gutenberg block 注释后再重写（避免误改 wp: 标记）');}
var rew=await postForm({action:'wp_aiw_rewrite_generate_current',nonce:wpAiwWriterMetabox.nonce,postId:String(postId),title:curTitle,content:curContentForModel,language:language,rewriteTitle:rewriteTitle?'1':'0',requirements:requirements,urls:urls,referenceText:referenceText,debug:debug,});var nextHtmlR=rew.contentHtml||'';if(!nextHtmlR){throw new Error('返回内容为空（content_html）');}
setEditorContent(nextHtmlR);if(rewriteTitle&&rew.title){setEditorTitle(rew.title);}
var tagResR=null;try{tagResR=applyTagsToClassicEditorOverwrite(rew.tags||[]);if(!tagResR||!tagResR.ok){tagResR=await applyTagsToBlockEditorOverwrite(rew.tags||[]);}}catch(eTR){tagResR=tagResR;}
if(tagResR&&tagResR.ok){logLine('tags 已同步到当前文章（覆盖写入，数量：'+((rew.tags&&rew.tags.length)?rew.tags.length:0)+'）');}else{logLine('tags 已返回，但未能自动同步到编辑器 UI');}
logLine('已重写并写入当前文章编辑器（未保存）');var debugHtmlR='';if(rew.debug){debugHtmlR='<details style="margin-top:6px;"><summary>调试信息</summary><pre style="white-space:pre-wrap;">'+escapeHtml(JSON.stringify(rew.debug,null,2))+'</pre></details>';}
setResult('<div style="padding:8px;background:#fff;border:1px solid #dcdcde;border-radius:4px;">'+'<p style="margin:0 0 6px 0;"><strong>已重写当前文章</strong>（请记得保存/更新）</p>'+'<p style="margin:0;"><strong>标题：</strong>'+escapeHtml((rewriteTitle&&rew.title)?rew.title:(curTitle||title))+'</p>'+
debugHtmlR+'</div>');setStatus('成功（未保存）');lockButton('成功（未保存）');}else{throw new Error('未知模式：'+mode);}}catch(e){setStatus('失败');logLine('错误：'+(e&&e.message?e.message:String(e)));if(debug==='1'&&e&&e.payload&&e.payload.data&&e.payload.data.debug){try{var dbg=e.payload.data.debug;if(dbg&&typeof dbg.raw==='string'){logLine('调试(raw)：'+truncateForLog(dbg.raw,800));}else{logLine('调试：'+truncateForLog(JSON.stringify(dbg),800));}}catch(eDbg){}}
lockButton('失败（看日志）');}finally{if(!btnLocked){btn.disabled=false;btn.textContent=btnLabelIdle;}}});(function bindImageUi(){var genBtn=$('wp-aiw-writer-mb-image-generate');var insBtn=$('wp-aiw-writer-mb-image-insert');if(!genBtn||!insBtn)return;var featBtn=$('wp-aiw-writer-mb-image-featured');var cfg=getImageCfg();if(!cfg.enabled){genBtn.disabled=true;insBtn.disabled=true;setImageStatus('未启用（请在设置页开启 image_enabled）');return;}
var sizeSel=$('wp-aiw-writer-mb-image-size');if(sizeSel){if(cfg.provider==='gemini_generatecontent'){sizeSel.disabled=true;sizeSel.value='';}else if(!sizeSel.value&&cfg.defaultSize){for(var i=0;i<sizeSel.options.length;i++){if(sizeSel.options[i].value===cfg.defaultSize){sizeSel.value=cfg.defaultSize;break;}}}}
function canInsertMore(){var max=cfg.maxPerPost;if(!max||isNaN(max))return true;return imageState.insertedCount<max;}
function refreshInsertBtn(){var ok=(!!imageState.b64||!!imageState.url)&&canInsertMore();insBtn.disabled=!ok;if(featBtn){var postId0=($('wp-aiw-writer-mb-post-id')&&$('wp-aiw-writer-mb-post-id').value)?parseInt($('wp-aiw-writer-mb-post-id').value,10):0;var okFeat=(!!imageState.b64||!!imageState.url)&&postId0>0;featBtn.disabled=!okFeat;}
if(!!imageState.b64&&!canInsertMore()){setImageStatus('已达到每篇最大插图数量限制');}}
async function ensureUploadedToMedia(altText){if(imageState.attachmentId&&imageState.attachmentId>0){return{attachmentId:imageState.attachmentId};}
var postId=($('wp-aiw-writer-mb-post-id')&&$('wp-aiw-writer-mb-post-id').value)?$('wp-aiw-writer-mb-post-id').value:'';if(!postId||parseInt(postId,10)<=0){throw new Error('请先保存文章/草稿后再执行此操作');}
var up=await postForm({action:'wp_aiw_upload_image',nonce:wpAiwWriterMetabox.nonce,postId:postId,b64:imageState.b64,url:imageState.url,mime:imageState.mime,title:altText,alt:altText,});if(!up||!up.attachmentId){throw new Error('入库成功但缺少 attachmentId');}
imageState.attachmentId=parseInt(up.attachmentId,10)||0;return{attachmentId:imageState.attachmentId,url:up.url||''};}
genBtn.addEventListener('click',async function(){var title=($('wp-aiw-writer-mb-title')&&$('wp-aiw-writer-mb-title').value)?$('wp-aiw-writer-mb-title').value.trim():'';if(!title)title=getEditorTitle();var requirements=($('wp-aiw-writer-mb-req')&&$('wp-aiw-writer-mb-req').value)?$('wp-aiw-writer-mb-req').value.trim():'';var language=($('wp-aiw-writer-mb-lang')&&$('wp-aiw-writer-mb-lang').value)?$('wp-aiw-writer-mb-lang').value:'zh';var styleHint=($('wp-aiw-writer-mb-image-style')&&$('wp-aiw-writer-mb-image-style').value)?String($('wp-aiw-writer-mb-image-style').value).trim():'';var excerptText=($('wp-aiw-writer-mb-image-excerpt')&&$('wp-aiw-writer-mb-image-excerpt').value)?$('wp-aiw-writer-mb-image-excerpt').value.trim():'';var size=(cfg.provider==='gemini_generatecontent')?'':((sizeSel&&sizeSel.value)?sizeSel.value:'');var debug=$('wp-aiw-writer-mb-debug')&&$('wp-aiw-writer-mb-debug').checked?'1':'';if(!title){setImageStatus('请先填写标题');return;}
if(!canInsertMore()){setImageStatus('已达到每篇最大插图数量限制');return;}
genBtn.disabled=true;insBtn.disabled=true;setImageStatus('生成中…');logLine('开始生成插图预览…');try{var r=await postForm({action:'wp_aiw_generate_image',nonce:wpAiwWriterMetabox.nonce,title:title,requirements:requirements,language:language,styleHint:styleHint,excerptText:excerptText,size:size,debug:debug,});imageState.b64=r.b64||'';imageState.url=r.url||'';imageState.mime=r.mime||'image/png';imageState.promptUsed=r.promptUsed||'';imageState.attachmentId=0;if(!imageState.b64&&!imageState.url){throw new Error('返回图片数据为空（b64/url）');}
var previewSrc='';if(imageState.b64){previewSrc='data:'+imageState.mime+';base64,'+imageState.b64;}else{previewSrc=imageState.url;}
showImagePreview(previewSrc);setImageStatus('预览已生成（插入会入库媒体库）');logLine('插图预览已生成');refreshInsertBtn();if(r.debug){logLine('插图调试：'+JSON.stringify(r.debug));}}catch(e){setImageStatus('失败');logLine('插图错误：'+(e&&e.message?e.message:String(e)));}finally{genBtn.disabled=false;refreshInsertBtn();}});insBtn.addEventListener('click',async function(){if(!imageState.b64&&!imageState.url){setImageStatus('请先生成预览');return;}
if(!canInsertMore()){setImageStatus('已达到每篇最大插图数量限制');return;}
var postId=($('wp-aiw-writer-mb-post-id')&&$('wp-aiw-writer-mb-post-id').value)?$('wp-aiw-writer-mb-post-id').value:'';var alt=($('wp-aiw-writer-mb-title')&&$('wp-aiw-writer-mb-title').value)?$('wp-aiw-writer-mb-title').value.trim():'';if(!alt)alt=getEditorTitle();insBtn.disabled=true;setImageStatus('插入中…');logLine('开始插入插图…');try{var up=await postForm({action:'wp_aiw_upload_image',nonce:wpAiwWriterMetabox.nonce,postId:postId,b64:imageState.b64,url:imageState.url,mime:imageState.mime,title:alt,alt:alt,});if(!up.url){throw new Error('入库成功但缺少 url');}
insertHtmlIntoEditor(buildImgHtml(up.url,alt),'cursor');imageState.attachmentId=parseInt(up.attachmentId,10)||0;imageState.insertedCount++;setImageStatus('已入库并插入正文（未保存）');logLine('插图已入库并插入正文（attachmentId='+up.attachmentId+'）');}catch(e2){setImageStatus('失败');logLine('插入错误：'+(e2&&e2.message?e2.message:String(e2)));}finally{refreshInsertBtn();}});refreshInsertBtn();if(featBtn){featBtn.addEventListener('click',async function(){if(!imageState.b64&&!imageState.url){setImageStatus('请先生成预览');return;}
var postId=($('wp-aiw-writer-mb-post-id')&&$('wp-aiw-writer-mb-post-id').value)?$('wp-aiw-writer-mb-post-id').value:'';if(!postId||parseInt(postId,10)<=0){setImageStatus('请先保存文章/草稿后再设为特色图');return;}
var alt=($('wp-aiw-writer-mb-title')&&$('wp-aiw-writer-mb-title').value)?$('wp-aiw-writer-mb-title').value.trim():'';if(!alt)alt=getEditorTitle();featBtn.disabled=true;setImageStatus('设置中…');logLine('开始设为特色图…');try{var up2=await ensureUploadedToMedia(alt);var res=await postForm({action:'wp_aiw_set_featured_image',nonce:wpAiwWriterMetabox.nonce,postId:postId,attachmentId:up2.attachmentId,});try{var box=document.getElementById('postimagediv');if(box&&res&&res.html){var inside=box.querySelector('.inside');if(inside)inside.innerHTML=res.html;}}catch(e3){}
setImageStatus('已设为特色图（未保存）');logLine('已设为特色图（attachmentId='+up2.attachmentId+'）');}catch(e4){setImageStatus('失败');logLine('特色图错误：'+(e4&&e4.message?e4.message:String(e4)));}finally{refreshInsertBtn();}});}})();}
if(document.readyState==='loading'){document.addEventListener('DOMContentLoaded',bind);}else{bind();}})();