(function(){'use strict';function $(id){return document.getElementById(id);}
function escapeHtml(str){return String(str).replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&#039;');}
function logLine(msg){var el=$('wp-aiw-writer-url-log');if(!el)return;var div=document.createElement('div');div.textContent=msg;el.appendChild(div);el.scrollTop=el.scrollHeight;}
function setStatus(msg){var el=$('wp-aiw-writer-url-status');if(!el)return;el.textContent=msg;}
function setResult(html){var el=$('wp-aiw-writer-url-result');if(!el)return;el.innerHTML=html;}
function splitUrls(raw){raw=String(raw||'').trim();if(!raw)return[];return raw.split(/\r\n|\r|\n/).map(function(s){return String(s||'').trim();}).filter(function(s){return!!s;});}
async function postForm(payload){var body=new URLSearchParams(payload);var resp=await fetch(wpAiwWriter.ajaxUrl,{method:'POST',credentials:'same-origin',headers:{'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'},body:body.toString(),});var data;try{data=await resp.json();}catch(e){throw new Error('响应不是 JSON');}
if(!data||data.success!==true){var msg=(data&&data.data&&data.data.message)?data.data.message:'请求失败';var err=new Error(msg);err.payload=data;throw err;}
return data.data;}
function bind(){var btn=$('wp-aiw-writer-url-generate');if(!btn)return;btn.addEventListener('click',async function(){var urls=($('wp-aiw-writer-url-urls')&&$('wp-aiw-writer-url-urls').value)?$('wp-aiw-writer-url-urls').value.trim():'';var referenceText=($('wp-aiw-writer-url-ref')&&$('wp-aiw-writer-url-ref').value)?$('wp-aiw-writer-url-ref').value.trim():'';var requirements=($('wp-aiw-writer-url-req')&&$('wp-aiw-writer-url-req').value)?$('wp-aiw-writer-url-req').value.trim():'';var language=($('wp-aiw-writer-url-lang')&&$('wp-aiw-writer-url-lang').value)?$('wp-aiw-writer-url-lang').value:'zh';var debug=$('wp-aiw-writer-url-debug')&&$('wp-aiw-writer-url-debug').checked?'1':'';var autoFeatured=$('wp-aiw-writer-url-auto-featured')&&$('wp-aiw-writer-url-auto-featured').checked;$('wp-aiw-writer-url-log').innerHTML='';setResult('');if(!urls){setStatus('请先填写 URL');return;}
var urlList=splitUrls(urls);if(!urlList.length){setStatus('请先填写 URL（每行一个，最多 3 个）');return;}
if(urlList.length>3){setStatus('最多 3 个 URL，请删减后再提交');logLine('你输入了 '+urlList.length+' 个 URL（最多 3 个）。');return;}
btn.disabled=true;setStatus('抓取并生成中…');logLine('开始抓取 URL 并生成草稿…');try{var result=await postForm({action:'wp_aiw_writer_generate_draft_from_urls',nonce:wpAiwWriter.nonce,urls:urls,referenceText:referenceText,requirements:requirements,language:language,debug:debug,});logLine('草稿已创建：ID='+result.postId);if(result.urlErrors&&result.urlErrors.length){logLine('部分 URL 抓取失败（已忽略失败项并继续生成）：');for(var i=0;i<result.urlErrors.length;i++){logLine('- '+result.urlErrors[i]);}}
if(result.tags&&result.tags.length){logLine('tags 已返回（数量：'+result.tags.length+'）');}else{logLine('tags 未返回或为空');}
var imageNote='';if(autoFeatured){if(!window.wpAiwFeaturedImage||!window.wpAiwFeaturedImage.runOptional){imageNote='跳过（缺少 featured-image 脚本）';logLine('特色图：'+imageNote);}else{logLine('特色图：开始生成并设置…');var imgOpt=await window.wpAiwFeaturedImage.runOptional({enabled:true,flags:{imageEnabled:wpAiwWriter.imageEnabled,},ajaxUrl:wpAiwWriter.ajaxUrl,nonce:wpAiwWriter.nonce,postId:result.postId,title:result.title||'',language:language,debug:debug==='1',});imageNote=imgOpt&&imgOpt.message?imgOpt.message:'';if(imgOpt&&imgOpt.status==='done'){logLine('特色图：'+imageNote);}else if(imgOpt&&imgOpt.status==='skipped'){logLine('特色图：'+imageNote);}else if(imgOpt&&imgOpt.status==='failed'){logLine('特色图：'+imageNote+'（不影响草稿）');}else{logLine('特色图：失败（未知错误）（不影响草稿）');}}}
var linkHtml='';if(result.editUrl){linkHtml='<p><a href="'+escapeHtml(result.editUrl)+'" target="_blank" rel="noopener">打开草稿编辑页</a></p>';}
var imageHtml='';if(autoFeatured){imageHtml='<p><strong>特色图：</strong>'+escapeHtml(imageNote||'')+'</p>';}
var warnHtml='';if(result.urlErrors&&result.urlErrors.length){var items='';for(var w=0;w<result.urlErrors.length;w++){items+='<li>'+escapeHtml(result.urlErrors[w])+'</li>';}
warnHtml='<div style="margin-top:8px; padding:10px; background:#fff8e5; border:1px solid #f0c36d; border-radius:6px;">'+'<p style="margin:0 0 6px 0;"><strong>抓取告警</strong>（已忽略失败 URL，并继续生成）</p>'+'<ul style="margin:0; padding-left:18px;">'+items+'</ul>'+'</div>';}
var debugHtml='';if(result.debug){debugHtml='<details style="margin-top:8px;"><summary>调试信息</summary><pre style="white-space:pre-wrap;">'+escapeHtml(JSON.stringify(result.debug,null,2))+'</pre></details>';}
setResult('<div style="padding:12px;background:#fff;border:1px solid #dcdcde;border-radius:6px;">'+'<p><strong>标题：</strong>'+escapeHtml(result.title||'')+'</p>'+
linkHtml+
imageHtml+
warnHtml+
debugHtml+'</div>');setStatus('完成');}catch(e){setStatus('失败');logLine('错误：'+(e&&e.message?e.message:String(e)));var debugObj=(e&&e.payload&&e.payload.data&&e.payload.data.debug)?e.payload.data.debug:null;if(debugObj&&debugObj.url_errors&&debugObj.url_errors.length){logLine('失败 URL 列表：');for(var j=0;j<debugObj.url_errors.length;j++){logLine('- '+debugObj.url_errors[j]);}}else if(debugObj&&debug==='1'){logLine('调试：'+JSON.stringify(debugObj));}
var errMsg=(e&&e.message)?String(e.message):String(e);var errHtml='';var failedItems='';if(debugObj&&debugObj.url_errors&&debugObj.url_errors.length){for(var k=0;k<debugObj.url_errors.length;k++){failedItems+='<li>'+escapeHtml(debugObj.url_errors[k])+'</li>';}}
var failedHtml='';if(failedItems){failedHtml='<div style="margin-top:8px;">'+'<div style="margin:0 0 6px 0;"><strong>失败 URL 列表</strong></div>'+'<ul style="margin:0; padding-left:18px;">'+failedItems+'</ul>'+'</div>';}
var debugHtml='';if(debug==='1'&&debugObj){debugHtml='<details style="margin-top:8px;"><summary>调试信息</summary>'+'<pre style="white-space:pre-wrap; margin:6px 0 0 0;">'+escapeHtml(JSON.stringify(debugObj,null,2))+'</pre>'+'</details>';}
errHtml='<div style="padding:12px;background:#fff;border:1px solid #d63638;border-radius:6px;">'+'<p style="margin:0 0 6px 0;"><strong>生成失败</strong></p>'+'<p style="margin:0; color:#8a2424;">'+escapeHtml(errMsg)+'</p>'+
failedHtml+
debugHtml+'</div>';setResult(errHtml);}finally{btn.disabled=false;}});}
if(document.readyState==='loading'){document.addEventListener('DOMContentLoaded',bind);}else{bind();}})();