(function(){'use strict';var STORAGE_KEY='wp_aiw_writer_batch_v1';function $(id){return document.getElementById(id);}
function escapeHtml(str){return String(str).replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&#039;');}
function nowIso(){try{return new Date().toISOString();}catch(e){return'';}}
function parseLines(text){text=String(text||'').trim();if(!text)return[];var lines=text.split(/\r\n|\r|\n/);var out=[];for(var i=0;i<lines.length;i++){var t=String(lines[i]||'').trim();if(!t)continue;out.push(t);}
var seen={};var uniq=[];for(var j=0;j<out.length;j++){if(seen[out[j]])continue;seen[out[j]]=true;uniq.push(out[j]);}
return uniq;}
function parseTaskLine(line){line=String(line||'').trim();if(!line)return null;var parts=line.split('||');var title=String(parts[0]||'').trim();if(!title)return null;var urlsPart=(parts.length>=2)?String(parts[1]||'').trim():'';var refPart=(parts.length>=3)?String(parts.slice(2).join('||')||'').trim():'';var urls=[];if(urlsPart){var raw=urlsPart.split(/[，,\s]+/);for(var i=0;i<raw.length;i++){var u=String(raw[i]||'').trim();if(!u)continue;urls.push(u);}
var seen={};var uniq=[];for(var k=0;k<urls.length;k++){if(seen[urls[k]])continue;seen[urls[k]]=true;uniq.push(urls[k]);}
urls=uniq;}
return{title:title,urls:urls,referenceText:refPart,};}
function readState(){var raw;try{raw=localStorage.getItem(STORAGE_KEY);}catch(e){raw=null;}
if(!raw)return null;try{return JSON.parse(raw);}catch(e2){return null;}}
function writeState(state){try{localStorage.setItem(STORAGE_KEY,JSON.stringify(state));}catch(e){}}
function clearState(){try{localStorage.removeItem(STORAGE_KEY);}catch(e){}}
function setStatus(msg){var el=$('wp-aiw-writer-batch-status');var el2=$('wp-aiw-writer-batch-status2');if(el)el.textContent=msg||'';if(el2)el2.textContent=msg||'';}
async function postForm(payload){if(window.wpAiwFeaturedImage&&typeof window.wpAiwFeaturedImage.postForm==='function'){return window.wpAiwFeaturedImage.postForm(wpAiwWriterBatch.ajaxUrl,payload);}
var body=new URLSearchParams(payload);var resp=await fetch(wpAiwWriterBatch.ajaxUrl,{method:'POST',credentials:'same-origin',headers:{'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'},body:body.toString(),});var data;try{data=await resp.json();}catch(e){throw new Error('响应不是 JSON');}
if(!data||data.success!==true){var msg=(data&&data.data&&data.data.message)?data.data.message:'请求失败';var err=new Error(msg);err.payload=data;throw err;}
return data.data;}
function renderList(state){var listEl=$('wp-aiw-writer-batch-list');if(!listEl)return;var tasks=(state&&state.tasks)?state.tasks:[];var total=state&&state.total?state.total:(tasks.length||0);var done=state&&state.done?state.done:0;var failed=state&&state.failed?state.failed:0;var running=0;var pending=0;var failedCount=0;var failedSelectedCount=0;for(var i=0;i<tasks.length;i++){if(tasks[i].status==='running')running++;else pending++;if(tasks[i].status==='failed'){failedCount++;if(tasks[i].selected)failedSelectedCount++;}}
var allFailedSelected=(failedCount>0&&failedSelectedCount===failedCount);var html='';html+='<div style="margin-bottom:10px;">总数：'+total+'；完成：'+done+'；失败：'+failed+'；进行中：'+running+'；剩余：'+pending+'</div>';html+='<table class="widefat fixed striped">';html+='<thead><tr>'+'<th style="width:48px;">#</th>'+'<th style="width:56px;"><label><input type="checkbox" id="wp-aiw-writer-batch-select-all-failed" '+(allFailedSelected?'checked':'')+' /> 全选</label></th>'+'<th>标题</th>'+'<th style="width:120px;">状态</th>'+'<th style="width:120px;">草稿</th>'+'<th>备注</th>'+'</tr></thead>';html+='<tbody>';for(var j=0;j<tasks.length;j++){var t=tasks[j];var statusText=t.status;if(t.status==='pending')statusText='待处理';if(t.status==='running')statusText='生成中';if(t.status==='failed')statusText='失败';var canSelect=(t.status==='failed');var checked=!!t.selected;var link='';if(t.editUrl){link='<a href="'+escapeHtml(t.editUrl)+'" target="_blank" rel="noopener">打开</a>';}
var note='';if(t.error)note=escapeHtml(t.error);if(t.image&&t.image.status){if(note)note+=' / ';if(t.image.status==='done')note+='特色图：完成';else if(t.image.status==='skipped')note+='特色图：跳过';else if(t.image.status==='failed')note+='特色图：失败('+escapeHtml(t.image.error||'')+')';else if(t.image.status==='running')note+='特色图：进行中';}
html+='<tr>';html+='<td>'+(j+1)+'</td>';html+='<td><input type="checkbox" class="wp-aiw-writer-batch-task-check" data-task-id="'+escapeHtml(t.id||'')+'" '+(canSelect?'':'disabled')+' '+(checked?'checked':'')+' /></td>';html+='<td>'+escapeHtml(t.title||'')+'</td>';html+='<td>'+escapeHtml(statusText)+'</td>';html+='<td>'+link+'</td>';html+='<td>'+note+'</td>';html+='</tr>';}
html+='</tbody></table>';listEl.innerHTML=html;}
function showInput(show){var input=$('wp-aiw-writer-batch-input');var prog=$('wp-aiw-writer-batch-progress');if(input)input.style.display=show?'block':'none';if(prog)prog.style.display=show?'none':'block';}
function normalizeConcurrency(n){n=parseInt(n,10);if(!n||isNaN(n))n=1;if(n<1)n=1;if(n>10)n=10;return n;}
function hasUnfinished(tasks){return Array.isArray(tasks)&&tasks.length>0;}
async function runQueue(state){if(!state)return;state.running=true;state.paused=false;writeState(state);var concurrency=normalizeConcurrency(state.concurrency);function pickNext(){for(var i=0;i<state.tasks.length;i++){if(state.tasks[i].status==='pending')return state.tasks[i];}
return null;}
function hasPendingOrRunning(){for(var i=0;i<state.tasks.length;i++){if(state.tasks[i].status==='pending'||state.tasks[i].status==='running')return true;}
return false;}
function removeTaskById(taskId){var nextTasks=[];for(var i=0;i<state.tasks.length;i++){if(state.tasks[i].id!==taskId)nextTasks.push(state.tasks[i]);}
state.tasks=nextTasks;}
async function processOne(task){task.status='running';task.startedAt=nowIso();task.error='';writeState(state);renderList(state);try{var res=await postForm({action:'wp_aiw_writer_generate_draft',nonce:wpAiwWriterBatch.nonce,title:task.title,requirements:state.requirements||'',urls:Array.isArray(task.urls)&&task.urls.length?task.urls.join('\n'):'',referenceText:task.referenceText||'',language:state.language||'zh',debug:state.debug?'1':'',});task.postId=res.postId||0;task.editUrl=res.editUrl||'';task.resultTitle=res.title||task.title;task.tags=res.tags||[];if(state.autoFeatured){task.image={status:'running',error:''};writeState(state);renderList(state);try{if(!window.wpAiwFeaturedImage||!window.wpAiwFeaturedImage.runOptional){throw new Error('缺少 featured-image 脚本');}
var tagStr=Array.isArray(task.tags)?task.tags.join(', '):'';var imgOpt=await window.wpAiwFeaturedImage.runOptional({enabled:true,flags:{imageEnabled:wpAiwWriterBatch.imageEnabled,},ajaxUrl:wpAiwWriterBatch.ajaxUrl,nonce:wpAiwWriterBatch.nonce,postId:String(task.postId),title:task.resultTitle||task.title,requirements:tagStr,language:state.language||'zh',debug:!!state.debug,});if(imgOpt&&imgOpt.status==='done'){task.image={status:'done',attachmentId:imgOpt.attachmentId||0};}else if(imgOpt&&imgOpt.status==='skipped'){task.image={status:'skipped',error:imgOpt.message||'已跳过'};}else if(imgOpt&&imgOpt.status==='failed'){task.image={status:'failed',error:(imgOpt.error||imgOpt.message||'未知错误')};}else{task.image={status:'failed',error:'未知错误'};}}catch(eImg){task.image={status:'failed',error:(eImg&&eImg.message)?eImg.message:String(eImg)};}}
state.done=(state.done||0)+1;}catch(e){task.status='failed';task.error=(e&&e.message)?e.message:String(e);state.failed=(state.failed||0)+1;}
if(task.status!=='failed'){removeTaskById(task.id);}
writeState(state);renderList(state);}
var inFlight=0;return new Promise(function(resolve){function tick(){if(!state.running){return resolve();}
if(state.paused){setStatus('已暂停');return;}
while(inFlight<concurrency){var next=pickNext();if(!next)break;inFlight++;processOne(next).finally(function(){inFlight--;setTimeout(tick,0);});}
if(inFlight===0&&!hasPendingOrRunning()){state.running=false;state.paused=false;writeState(state);setStatus((state.failed||0)>0?'已完成（含失败项）':'全部完成');renderList(state);if(!state.tasks||state.tasks.length===0){clearState();}
return resolve();}}
tick();});}
function bind(){var startBtn=$('wp-aiw-writer-batch-start');var pauseBtn=$('wp-aiw-writer-batch-pause');var resumeBtn=$('wp-aiw-writer-batch-resume');var retryFailedBtn=$('wp-aiw-writer-batch-retry-failed');var retrySelectedBtn=$('wp-aiw-writer-batch-retry-selected');var deleteSelectedFailedBtn=$('wp-aiw-writer-batch-delete-selected-failed');var clearBtn=$('wp-aiw-writer-batch-clear');var clearBtn2=$('wp-aiw-writer-batch-clear2');var listEl=$('wp-aiw-writer-batch-list');var concurrencyEl=$('wp-aiw-writer-batch-concurrency');if(concurrencyEl&&(concurrencyEl.value===''||concurrencyEl.value==null)){concurrencyEl.value=String(normalizeConcurrency(wpAiwWriterBatch.defaultConcurrency||1));}
function refreshFromState(state){if(state&&state.tasks&&state.tasks.length&&hasUnfinished(state.tasks)){var titlesEl=$('wp-aiw-writer-batch-titles');if(titlesEl){try{var remain=[];for(var i=0;i<state.tasks.length;i++){var line=String(state.tasks[i].title||'').trim();var urls=Array.isArray(state.tasks[i].urls)?state.tasks[i].urls:[];var ref=String(state.tasks[i].referenceText||'').trim();if(urls.length||ref){line+=' || '+(urls.length?urls.join(', '):'')+' || '+(ref||'');}
remain.push(line);}
titlesEl.value=remain.join('\n');}catch(eT){}}
showInput(false);renderList(state);setStatus(state.paused?'已暂停（可继续）':(state.running?'运行中…':'可继续未完成任务'));}else{showInput(true);setStatus('');}}
var state=readState();if(state&&typeof state==='object'){refreshFromState(state);}else{refreshFromState(null);}
function clearUnfinished(){clearState();refreshFromState(null);}
function normalizeTaskForRetry(task){task.status='pending';task.error='';task.image=null;task.startedAt='';task.finishedAt='';task.selected=false;}
function retryFailed(onlySelected){var st=readState();if(!st||!Array.isArray(st.tasks)||st.tasks.length===0){setStatus('没有可重试的失败项');return;}
var changed=0;for(var i=0;i<st.tasks.length;i++){if(st.tasks[i].status!=='failed')continue;if(onlySelected&&!st.tasks[i].selected)continue;normalizeTaskForRetry(st.tasks[i]);changed++;}
if(changed<=0){setStatus(onlySelected?'未选择失败项':'没有可重试的失败项');return;}
st.failed=Math.max(0,(st.failed||0)-changed);st.paused=false;st.running=true;writeState(st);showInput(false);renderList(st);setStatus('重试中…');runQueue(st);}
function deleteSelectedFailed(){var st=readState();if(!st||!Array.isArray(st.tasks)||st.tasks.length===0){setStatus('没有可删除的失败项');return;}
var removed=0;var nextTasks=[];for(var i=0;i<st.tasks.length;i++){var t=st.tasks[i];if(t.status==='failed'&&t.selected){removed++;continue;}
nextTasks.push(t);}
if(removed<=0){setStatus('未选择失败项');return;}
st.tasks=nextTasks;st.failed=Math.max(0,(st.failed||0)-removed);st.total=Math.max(0,(st.total||0)-removed);writeState(st);if(!hasUnfinished(st.tasks)){clearState();refreshFromState(null);setStatus('已删除失败项');return;}
renderList(st);setStatus('已删除失败项（'+removed+'）');}
if(clearBtn)clearBtn.addEventListener('click',function(){clearUnfinished();});if(clearBtn2)clearBtn2.addEventListener('click',function(){clearUnfinished();});if(pauseBtn){pauseBtn.addEventListener('click',function(){var st=readState();if(!st)return;st.paused=true;st.running=true;writeState(st);setStatus('已暂停');refreshFromState(st);});}
if(resumeBtn){resumeBtn.addEventListener('click',function(){var st=readState();if(!st)return;st.paused=false;st.running=true;writeState(st);setStatus('继续中…');showInput(false);renderList(st);runQueue(st);});}
if(retryFailedBtn){retryFailedBtn.addEventListener('click',function(){retryFailed(false);});}
if(retrySelectedBtn){retrySelectedBtn.addEventListener('click',function(){retryFailed(true);});}
if(deleteSelectedFailedBtn){deleteSelectedFailedBtn.addEventListener('click',function(){deleteSelectedFailed();});}
if(listEl){listEl.addEventListener('change',function(ev){var target=ev&&ev.target?ev.target:null;if(!target)return;if(target.id==='wp-aiw-writer-batch-select-all-failed'){var st=readState();if(!st||!Array.isArray(st.tasks))return;var checked=!!target.checked;for(var i=0;i<st.tasks.length;i++){if(st.tasks[i].status==='failed'){st.tasks[i].selected=checked;}}
writeState(st);renderList(st);return;}
if(target.classList&&target.classList.contains('wp-aiw-writer-batch-task-check')){var taskId=target.getAttribute('data-task-id')||'';var st2=readState();if(!st2||!Array.isArray(st2.tasks))return;for(var j=0;j<st2.tasks.length;j++){if(String(st2.tasks[j].id)===String(taskId)){st2.tasks[j].selected=!!target.checked;break;}}
writeState(st2);}});}
if(startBtn){startBtn.addEventListener('click',function(){var rawText=($('wp-aiw-writer-batch-titles')&&$('wp-aiw-writer-batch-titles').value)?$('wp-aiw-writer-batch-titles').value:'';var rawLines=parseLines(rawText);var requirements=($('wp-aiw-writer-batch-req')&&$('wp-aiw-writer-batch-req').value)?$('wp-aiw-writer-batch-req').value.trim():'';var language=($('wp-aiw-writer-batch-lang')&&$('wp-aiw-writer-batch-lang').value)?$('wp-aiw-writer-batch-lang').value:'zh';var debug=$('wp-aiw-writer-batch-debug')&&$('wp-aiw-writer-batch-debug').checked;var concurrency=normalizeConcurrency(($('wp-aiw-writer-batch-concurrency')&&$('wp-aiw-writer-batch-concurrency').value)?$('wp-aiw-writer-batch-concurrency').value:(wpAiwWriterBatch.defaultConcurrency||1));var autoFeatured=$('wp-aiw-writer-batch-auto-featured')&&$('wp-aiw-writer-batch-auto-featured').checked;if(!rawLines.length){setStatus('请先输入任务（每行一个）');return;}
var tasks=[];for(var i=0;i<rawLines.length;i++){var parsed=parseTaskLine(rawLines[i]);if(!parsed)continue;tasks.push({id:String(Date.now())+'_'+String(i),title:parsed.title,urls:parsed.urls||[],referenceText:parsed.referenceText||'',status:'pending',postId:0,editUrl:'',error:'',image:null,createdAt:nowIso(),});}
if(!tasks.length){setStatus('任务解析失败：请检查格式（标题不能为空）');return;}
var st={running:true,paused:false,createdAt:nowIso(),requirements:requirements,language:language,debug:!!debug,concurrency:concurrency,autoFeatured:!!autoFeatured,total:tasks.length,done:0,failed:0,tasks:tasks,};writeState(st);showInput(false);renderList(st);setStatus('运行中…');runQueue(st);});}}
if(document.readyState==='loading'){document.addEventListener('DOMContentLoaded',bind);}else{bind();}})();