(function(){'use strict';var STORAGE_KEY='wp_aiw_featured_batch_state_v1';var LOG_LIMIT=220;var MAX_EXCLUDE=500;var isRunning=false;var processed=0;var failed=0;var inflight=0;var runToken=0;var doneReached=false;var excludedIds=[];var excludedMap=Object.create(null);var logLines=[];function $(id){return document.getElementById(id);}
function getConcurrency(){var raw=(window.wpAiwFeaturedBatch&&wpAiwFeaturedBatch.batchSize!=null)?wpAiwFeaturedBatch.batchSize:1;var n=parseInt(String(raw),10)||1;if(n<1)n=1;if(n>10)n=10;return n;}
function getMode(){var els=document.querySelectorAll('input[name="wp-aiw-fi-mode"]');if(!els||!els.length)return'missing_only';for(var i=0;i<els.length;i++){if(els[i]&&els[i].checked){var v=String(els[i].value||'').trim();return(v==='regenerate_all')?'regenerate_all':'missing_only';}}
return'missing_only';}
function getRunnerConfig(){var categoryEl=$('wp-aiw-fi-category');var includeChildrenEl=$('wp-aiw-fi-category-include-children');var tagEl=$('wp-aiw-fi-tag');var dateAfterEl=$('wp-aiw-fi-date-after');var dateBeforeEl=$('wp-aiw-fi-date-before');var authorEl=$('wp-aiw-fi-author');var orderEl=$('wp-aiw-fi-order');var languageEl=$('wp-aiw-fi-language');var skipFailedEl=$('wp-aiw-fi-skip-failed');var reqEl=$('wp-aiw-fi-req');var styleEl=$('wp-aiw-fi-style');var sizeEl=$('wp-aiw-fi-size');return{category_id:categoryEl?(parseInt(categoryEl.value,10)||0):0,category_include_children:includeChildrenEl?(includeChildrenEl.checked?1:0):1,tag_id:tagEl?(parseInt(tagEl.value,10)||0):0,author_id:authorEl?(parseInt(authorEl.value,10)||0):0,date_after:dateAfterEl?(dateAfterEl.value||''):'',date_before:dateBeforeEl?(dateBeforeEl.value||''):'',order_mode:orderEl?(orderEl.value||'oldest'):'oldest',language:languageEl?(languageEl.value||'zh'):'zh',mode:getMode(),skip_failed:skipFailedEl?(skipFailedEl.checked?1:0):1,requirements:reqEl?(reqEl.value||''):'',style_hint:styleEl?(styleEl.value||''):'',size:sizeEl?(sizeEl.value||''):''};}
function loadState(){try{var raw=localStorage.getItem(STORAGE_KEY);if(!raw)return null;var st=JSON.parse(raw);if(!st||typeof st!=='object')return null;if(st.v!==1)return null;return st;}catch(e){return null;}}
function saveState(extra){try{var st={v:1,isRunning:!!isRunning,processed:processed,failed:failed,excludedIds:excludedIds.slice(0,MAX_EXCLUDE),logLines:logLines.slice(Math.max(0,logLines.length-LOG_LIMIT)),cfg:getRunnerConfig(),concurrency:getConcurrency(),updatedAt:Date.now(),doneReached:!!doneReached};if(extra&&typeof extra==='object'){for(var k in extra)st[k]=extra[k];}
localStorage.setItem(STORAGE_KEY,JSON.stringify(st));}catch(e){}}
function clearState(){try{localStorage.removeItem(STORAGE_KEY);}catch(e){}}
function setStatus(text){var el=$('wp-aiw-fi-status');if(el)el.textContent=text;}
function updateStatus(){var c=getConcurrency();if(!isRunning&&!doneReached){setStatus('待开始');return;}
if(doneReached&&inflight===0){setStatus('完成：已成功 '+processed+' 篇，失败 '+failed+' 篇');return;}
if(!isRunning){setStatus('已停止：并发 '+c+'；已成功 '+processed+' 篇，失败 '+failed+' 篇');return;}
setStatus('处理中… 并发 '+c+'；进行中 '+inflight+'；已成功 '+processed+' 篇，失败 '+failed+' 篇');}
function renderLog(){var el=$('wp-aiw-fi-log');if(!el)return;el.innerHTML=logLines.join('');el.scrollTop=el.scrollHeight;}
function escapeHtml(str){var s=(str==null)?'':String(str);return s.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&#039;');}
function formatTs(){return new Date().toISOString().replace('T',' ').replace('Z','');}
function getAdminEditUrl(postId){var id=parseInt(String(postId),10);if(!id||id<=0)return'';var base=(window.wpAiwFeaturedBatch&&wpAiwFeaturedBatch.ajaxUrl)?String(wpAiwFeaturedBatch.ajaxUrl):(typeof ajaxurl!=='undefined'?String(ajaxurl):'');if(!base)return'/wp-admin/post.php?post='+id+'&action=edit';try{var u=new URL(base,window.location.href);u.pathname=u.pathname.replace(/\/admin-ajax\.php$/i,'/post.php');u.search='?post='+encodeURIComponent(String(id))+'&action=edit';u.hash='';return u.toString();}catch(e){return'/wp-admin/post.php?post='+id+'&action=edit';}}
function logHtml(innerHtml){var ts=formatTs();var full='<div class="wp-aiw-log-line">['+escapeHtml(ts)+'] '+innerHtml+'</div>';logLines.push(full);if(logLines.length>LOG_LIMIT){logLines=logLines.slice(logLines.length-LOG_LIMIT);}
renderLog();saveState();}
function logText(text){logHtml(escapeHtml(text));}
function logPostLine(prefix,postId,postTitle,message,extraHtml){var id=parseInt(String(postId),10)||0;var title=(postTitle==null)?'':String(postTitle);var href=getAdminEditUrl(id);var linkText='#'+id+(title?(' '+title):'');var link=href?'<a href="'+escapeHtml(href)+'" target="_blank" rel="noopener noreferrer" style="color:#93c5fd; text-decoration: underline;">'+escapeHtml(linkText)+'</a>':'<span>'+escapeHtml(linkText)+'</span>';var msg=(message==null)?'':String(message);var extra=extraHtml?String(extraHtml):'';logHtml(escapeHtml(prefix)+' '+link+'：'+escapeHtml(msg)+extra);}
function setButtons(){var start=$('wp-aiw-fi-start');var resume=$('wp-aiw-fi-resume');var stop=$('wp-aiw-fi-stop');var clearBtn=$('wp-aiw-fi-clear');if(start)start.disabled=isRunning;if(stop)stop.disabled=!isRunning;if(resume)resume.disabled=isRunning;if(clearBtn)clearBtn.disabled=isRunning;}
function hasHistoryState(){return(processed>0||failed>0||excludedIds.length>0||logLines.length>0||doneReached);}
function syncControlsVisibility(){var start=$('wp-aiw-fi-start');var resume=$('wp-aiw-fi-resume');if(resume){resume.style.display=hasHistoryState()?'':'none';}
if(start){start.textContent=hasHistoryState()?'重新开始':'开始';}}
function rememberExcludedId(postId){var id=parseInt(postId,10);if(!id||id<=0)return;if(excludedMap[id])return;excludedMap[id]=1;excludedIds.push(id);if(excludedIds.length>MAX_EXCLUDE){var removed=excludedIds.shift();if(removed)delete excludedMap[removed];}}
function buildRequestBody(cfg){var body=new URLSearchParams();body.set('action','wp_aiw_featured_batch_next');body.set('nonce',(window.wpAiwFeaturedBatch&&wpAiwFeaturedBatch.nonce)?wpAiwFeaturedBatch.nonce:'');body.set('category_id',String(cfg.category_id));body.set('category_include_children',String(cfg.category_include_children));body.set('tag_id',String(cfg.tag_id));body.set('author_id',String(cfg.author_id));body.set('date_after',cfg.date_after);body.set('date_before',cfg.date_before);body.set('order_mode',cfg.order_mode);body.set('language',cfg.language);body.set('mode',cfg.mode);body.set('skip_failed',String(cfg.skip_failed));body.set('requirements',cfg.requirements||'');body.set('style_hint',cfg.style_hint||'');body.set('size',cfg.size||'');if(cfg.skip_failed&&excludedIds.length>0){body.set('exclude_ids',excludedIds.join(','));}
return body;}
function schedule(token){if(!isRunning||token!==runToken)return;if(doneReached)return;var c=getConcurrency();while(inflight<c&&isRunning&&!doneReached&&token===runToken){startWorker(token);}}
function startWorker(token){if(!isRunning||token!==runToken)return;if(doneReached)return;inflight++;updateStatus();setButtons();var cfg=getRunnerConfig();var body=buildRequestBody(cfg);function finalize(){inflight=Math.max(0,inflight-1);updateStatus();if(doneReached&&inflight===0){isRunning=false;setButtons();updateStatus();saveState({isRunning:false});return;}
schedule(token);}
fetch((window.wpAiwFeaturedBatch&&wpAiwFeaturedBatch.ajaxUrl)?wpAiwFeaturedBatch.ajaxUrl:ajaxurl,{method:'POST',credentials:'same-origin',headers:{'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'},body:body.toString()}).then(function(r){return r.json();}).then(function(json){if(!isRunning||token!==runToken)return;if(!json||!json.success||!json.data){failed++;logText('请求异常：'+JSON.stringify(json));return;}
if(json.data.done){doneReached=true;logText(json.data.message||'全部完成');saveState({doneReached:true});return;}
if(json.data.ok){processed++;var extra='';if(json.data.deleted_attachment_id){extra+=' <span style="color:#fca5a5;">（已删除原特色图 attachmentId='+escapeHtml(String(json.data.deleted_attachment_id))+'）</span>';}
if(json.data.attachment_id){extra+=' <span style="color:#a7f3d0;">（新 attachmentId='+escapeHtml(String(json.data.attachment_id))+'）</span>';}
logPostLine('✅',json.data.post_id,json.data.post_title||'',json.data.message||'完成',extra);}else{failed++;var postId=json.data.post_id;var extra2='';if(cfg.skip_failed&&postId){rememberExcludedId(postId);extra2='（本次运行跳过，将处理下一篇）';}
logPostLine('❌',postId,json.data.post_title||'',(json.data.message||'失败')+extra2);}}).catch(function(e){if(!isRunning||token!==runToken)return;failed++;logText('请求错误：'+(e&&e.message?e.message:String(e)));}).finally(finalize);}
function applyCfgToUi(cfg){if(!cfg||typeof cfg!=='object')return;var categoryEl=$('wp-aiw-fi-category');var includeChildrenEl=$('wp-aiw-fi-category-include-children');var tagEl=$('wp-aiw-fi-tag');var dateAfterEl=$('wp-aiw-fi-date-after');var dateBeforeEl=$('wp-aiw-fi-date-before');var authorEl=$('wp-aiw-fi-author');var orderEl=$('wp-aiw-fi-order');var languageEl=$('wp-aiw-fi-language');var skipFailedEl=$('wp-aiw-fi-skip-failed');var reqEl=$('wp-aiw-fi-req');var styleEl=$('wp-aiw-fi-style');var sizeEl=$('wp-aiw-fi-size');if(categoryEl&&cfg.category_id!=null)categoryEl.value=String(cfg.category_id);if(includeChildrenEl&&cfg.category_include_children!=null)includeChildrenEl.checked=!!cfg.category_include_children;if(tagEl&&cfg.tag_id!=null)tagEl.value=String(cfg.tag_id);if(authorEl&&cfg.author_id!=null)authorEl.value=String(cfg.author_id);if(dateAfterEl&&cfg.date_after!=null)dateAfterEl.value=String(cfg.date_after);if(dateBeforeEl&&cfg.date_before!=null)dateBeforeEl.value=String(cfg.date_before);if(orderEl&&cfg.order_mode!=null)orderEl.value=String(cfg.order_mode);if(languageEl&&cfg.language!=null)languageEl.value=String(cfg.language);if(skipFailedEl&&cfg.skip_failed!=null)skipFailedEl.checked=!!cfg.skip_failed;if(reqEl&&cfg.requirements!=null)reqEl.value=String(cfg.requirements);if(styleEl&&cfg.style_hint!=null)styleEl.value=String(cfg.style_hint);if(sizeEl&&cfg.size!=null)sizeEl.value=String(cfg.size);var mode=(cfg.mode==='regenerate_all')?'regenerate_all':'missing_only';var modeEls=document.querySelectorAll('input[name="wp-aiw-fi-mode"]');if(modeEls&&modeEls.length){for(var i=0;i<modeEls.length;i++){if(modeEls[i])modeEls[i].checked=(String(modeEls[i].value)===mode);}}}
function resetRuntime(){processed=0;failed=0;inflight=0;doneReached=false;excludedIds=[];excludedMap=Object.create(null);logLines=[];renderLog();updateStatus();}
function canRun(){if(window.wpAiwFeaturedImage&&typeof wpAiwFeaturedImage.canAutoFeatured==='function'){return wpAiwFeaturedImage.canAutoFeatured({imageEnabled:wpAiwFeaturedBatch&&wpAiwFeaturedBatch.imageEnabled});}
return true;}
function initFromState(){var st=loadState();if(!st){syncControlsVisibility();setButtons();updateStatus();return;}
processed=parseInt(String(st.processed||0),10)||0;failed=parseInt(String(st.failed||0),10)||0;doneReached=!!st.doneReached;excludedIds=Array.isArray(st.excludedIds)?st.excludedIds.slice(0,MAX_EXCLUDE):[];excludedMap=Object.create(null);for(var i=0;i<excludedIds.length;i++)excludedMap[excludedIds[i]]=1;logLines=Array.isArray(st.logLines)?st.logLines.slice(Math.max(0,st.logLines.length-LOG_LIMIT)):[];renderLog();applyCfgToUi(st.cfg);syncControlsVisibility();setButtons();updateStatus();}
function bind(){var start=$('wp-aiw-fi-start');var resume=$('wp-aiw-fi-resume');var stop=$('wp-aiw-fi-stop');var clearBtn=$('wp-aiw-fi-clear');function startRun(resetAll){if(!canRun()){alert('图片相关设置未启用：需要开启 image_enabled。');return;}
if(resetAll){resetRuntime();}
var mode=getMode();if(mode==='regenerate_all'){var ok=confirm('你选择了“重新生成所有特色图”。这会先删除原特色图附件（媒体库文件）。确认继续？');if(!ok)return;}
isRunning=true;runToken++;var token=runToken;saveState({isRunning:true});syncControlsVisibility();setButtons();updateStatus();schedule(token);}
if(start){start.addEventListener('click',function(){startRun(true);});}
if(resume){resume.addEventListener('click',function(){startRun(false);});}
if(stop){stop.addEventListener('click',function(){isRunning=false;saveState({isRunning:false});setButtons();updateStatus();});}
if(clearBtn){clearBtn.addEventListener('click',function(){if(isRunning)return;clearState();resetRuntime();syncControlsVisibility();setButtons();});}
var cfgEls=document.querySelectorAll('#wp-aiw-fi-category, #wp-aiw-fi-category-include-children, #wp-aiw-fi-tag, #wp-aiw-fi-date-after, #wp-aiw-fi-date-before, #wp-aiw-fi-author, #wp-aiw-fi-order, #wp-aiw-fi-language, #wp-aiw-fi-skip-failed, #wp-aiw-fi-req, #wp-aiw-fi-style, #wp-aiw-fi-size, input[name="wp-aiw-fi-mode"]');for(var i=0;i<cfgEls.length;i++){cfgEls[i].addEventListener('change',function(){saveState();});}
var reqEl=$('wp-aiw-fi-req');if(reqEl){reqEl.addEventListener('input',function(){saveState();});}}
initFromState();bind();})();