(function(){'use strict';var STORAGE_KEY='wp_aiw_runner_state_v1';var LOG_LIMIT=220;var MAX_EXCLUDE=500;var isRunning=false;var processed=0;var failed=0;var inflight=0;var runToken=0;var doneReached=false;var excludedIds=[];var excludedMap=Object.create(null);var logLines=[];function $(id){return document.getElementById(id);}
function getConcurrency(){var raw=(window.wpAiw&&wpAiw.batchSize!=null)?wpAiw.batchSize:1;var n=parseInt(String(raw),10)||1;if(n<1)n=1;if(n>10)n=10;return n;}
function getRunnerConfig(){var categoryEl=document.getElementById('wp-aiw-category');var includeChildrenEl=document.getElementById('wp-aiw-category-include-children');var tagEl=document.getElementById('wp-aiw-tag');var dateAfterEl=document.getElementById('wp-aiw-date-after');var dateBeforeEl=document.getElementById('wp-aiw-date-before');var authorEl=document.getElementById('wp-aiw-author');var orderEl=document.getElementById('wp-aiw-order');var languageEl=document.getElementById('wp-aiw-language');var rewriteTitleEl=document.getElementById('wp-aiw-rewrite-title');var skipFailedEl=document.getElementById('wp-aiw-skip-failed');var forceRewriteEl=document.getElementById('wp-aiw-force-rewrite');return{category_id:categoryEl?(parseInt(categoryEl.value,10)||0):0,category_include_children:includeChildrenEl?(includeChildrenEl.checked?1:0):1,tag_id:tagEl?(parseInt(tagEl.value,10)||0):0,author_id:authorEl?(parseInt(authorEl.value,10)||0):0,date_after:dateAfterEl?(dateAfterEl.value||''):'',date_before:dateBeforeEl?(dateBeforeEl.value||''):'',order_mode:orderEl?(orderEl.value||'oldest'):'oldest',language:languageEl?(languageEl.value||'zh'):'zh',rewrite_title:rewriteTitleEl?(rewriteTitleEl.checked?1:0):0,skip_failed:skipFailedEl?(skipFailedEl.checked?1:0):1,force_rewrite:forceRewriteEl?(forceRewriteEl.checked?1:0):0};}
function loadState(){try{var raw=localStorage.getItem(STORAGE_KEY);if(!raw)return null;var st=JSON.parse(raw);if(!st||typeof st!=='object')return null;if(st.v!==1)return null;return st;}catch(e){return null;}}
function saveState(extra){try{var st={v:1,isRunning:!!isRunning,processed:processed,failed:failed,excludedIds:excludedIds.slice(0,MAX_EXCLUDE),logLines:logLines.slice(Math.max(0,logLines.length-LOG_LIMIT)),cfg:getRunnerConfig(),concurrency:getConcurrency(),updatedAt:Date.now(),doneReached:!!doneReached};if(extra&&typeof extra==='object'){for(var k in extra)st[k]=extra[k];}
localStorage.setItem(STORAGE_KEY,JSON.stringify(st));}catch(e){}}
function clearState(){try{localStorage.removeItem(STORAGE_KEY);}catch(e){}}
function setStatus(text){var el=$('wp-aiw-status');if(el)el.textContent=text;}
function updateStatus(){var c=getConcurrency();if(!isRunning&&!doneReached){setStatus('待开始');return;}
if(doneReached&&inflight===0){setStatus('完成：已成功 '+processed+' 篇，失败 '+failed+' 篇');return;}
if(!isRunning){setStatus('已停止：并发 '+c+'；已成功 '+processed+' 篇，失败 '+failed+' 篇');return;}
setStatus('处理中… 并发 '+c+'；进行中 '+inflight+'；已成功 '+processed+' 篇，失败 '+failed+' 篇');}
function renderLog(){var el=$('wp-aiw-log');if(!el)return;el.innerHTML=logLines.join('');el.scrollTop=el.scrollHeight;}
function escapeHtml(str){var s=(str==null)?'':String(str);return s.replace(/&/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;').replace(/"/g,'&quot;').replace(/'/g,'&#039;');}
function formatTs(){return new Date().toISOString().replace('T',' ').replace('Z','');}
function getAdminEditUrl(postId){var id=parseInt(String(postId),10);if(!id||id<=0)return'';var base=(window.wpAiw&&wpAiw.ajaxUrl)?String(wpAiw.ajaxUrl):(typeof ajaxurl!=='undefined'?String(ajaxurl):'');if(!base)return'/wp-admin/post.php?post='+id+'&action=edit';try{var u=new URL(base,window.location.href);u.pathname=u.pathname.replace(/\/admin-ajax\.php$/i,'/post.php');u.search='?post='+encodeURIComponent(String(id))+'&action=edit';u.hash='';return u.toString();}catch(e){return'/wp-admin/post.php?post='+id+'&action=edit';}}
function logHtml(innerHtml){var ts=formatTs();var full='<div class="wp-aiw-log-line">['+escapeHtml(ts)+'] '+innerHtml+'</div>';logLines.push(full);if(logLines.length>LOG_LIMIT){logLines=logLines.slice(logLines.length-LOG_LIMIT);}
renderLog();saveState();}
function logText(text){logHtml(escapeHtml(text));}
function logPostLine(prefix,postId,postTitle,message,extraHtml){var id=parseInt(String(postId),10)||0;var title=(postTitle==null)?'':String(postTitle);var href=getAdminEditUrl(id);var linkText='#'+id+(title?(' '+title):'');var link=href?'<a href="'+escapeHtml(href)+'" target="_blank" rel="noopener noreferrer" style="color:#93c5fd; text-decoration: underline;">'+escapeHtml(linkText)+'</a>':'<span>'+escapeHtml(linkText)+'</span>';var msg=(message==null)?'':String(message);var extra=extraHtml?String(extraHtml):'';logHtml(escapeHtml(prefix)+' '+link+'：'+escapeHtml(msg)+extra);}
function setButtons(){var start=$('wp-aiw-start');var resume=$('wp-aiw-resume');var stop=$('wp-aiw-stop');var clearBtn=$('wp-aiw-clear');if(start)start.disabled=isRunning;if(stop)stop.disabled=!isRunning;if(resume)resume.disabled=isRunning;if(clearBtn)clearBtn.disabled=isRunning;}
function hasHistoryState(){return(processed>0||failed>0||excludedIds.length>0||logLines.length>0||doneReached);}
function syncControlsVisibility(){var start=$('wp-aiw-start');var resume=$('wp-aiw-resume');if(resume){resume.style.display=hasHistoryState()?'':'none';}
if(start){start.textContent=hasHistoryState()?'重新开始':'开始';}}
function rememberExcludedId(postId){var id=parseInt(postId,10);if(!id||id<=0)return;if(excludedMap[id])return;excludedMap[id]=1;excludedIds.push(id);if(excludedIds.length>MAX_EXCLUDE){var removed=excludedIds.shift();if(removed)delete excludedMap[removed];}}
function buildRequestBody(cfg){var body=new URLSearchParams();body.set('action','wp_aiw_process_next');body.set('nonce',(window.wpAiw&&wpAiw.nonce)?wpAiw.nonce:'');body.set('category_id',String(cfg.category_id));body.set('category_include_children',String(cfg.category_include_children));body.set('tag_id',String(cfg.tag_id));body.set('author_id',String(cfg.author_id));body.set('date_after',cfg.date_after);body.set('date_before',cfg.date_before);body.set('order_mode',cfg.order_mode);body.set('language',cfg.language);body.set('rewrite_title',String(cfg.rewrite_title));body.set('skip_failed',String(cfg.skip_failed));body.set('force_rewrite',String(cfg.force_rewrite));if(cfg.skip_failed&&excludedIds.length>0){body.set('exclude_ids',excludedIds.join(','));}
return body;}
function startWorker(token){if(!isRunning||token!==runToken)return;if(doneReached)return;inflight++;updateStatus();setButtons();var cfg=getRunnerConfig();var body=buildRequestBody(cfg);function finalize(){inflight=Math.max(0,inflight-1);updateStatus();if(doneReached&&inflight===0){isRunning=false;setButtons();updateStatus();saveState({isRunning:false});return;}
schedule(token);}
fetch((window.wpAiw&&wpAiw.ajaxUrl)?wpAiw.ajaxUrl:ajaxurl,{method:'POST',credentials:'same-origin',headers:{'Content-Type':'application/x-www-form-urlencoded; charset=UTF-8'},body:body.toString()}).then(function(r){return r.json();}).then(function(json){if(!isRunning||token!==runToken)return;if(!json||!json.success||!json.data){failed++;logText('请求异常：'+JSON.stringify(json));return;}
if(json.data.done){doneReached=true;logText(json.data.message||'全部完成');saveState({doneReached:true});return;}
if(json.data.ok){processed++;var tagsInserted=Array.isArray(json.data.tags_added)&&json.data.tags_added.length>0;var tagsHint=tagsInserted?('<span style="color:#a7f3d0;">；标签已返回并插入</span>'):'';logPostLine('✅',json.data.post_id,json.data.post_title||'',json.data.message||'完成',tagsHint);}else{failed++;var postId=json.data.post_id;var extra='';if(cfg.skip_failed&&postId){rememberExcludedId(postId);extra='（本次运行跳过，将处理下一篇）';}
logPostLine('❌',postId,json.data.post_title||'',(json.data.message||'失败')+extra);if(json.data.raw){logText('RAW: '+(typeof json.data.raw==='string'?json.data.raw:JSON.stringify(json.data.raw)));}}
updateStatus();saveState();}).catch(function(err){if(!isRunning||token!==runToken)return;failed++;logText('请求报错：'+(err&&err.message?err.message:String(err)));updateStatus();saveState();}).then(function(){finalize();});}
function schedule(token){if(!isRunning||token!==runToken)return;if(doneReached)return;var c=getConcurrency();while(isRunning&&token===runToken&&!doneReached&&inflight<c){startWorker(token);}}
function startRun(isResume){if(isRunning)return;isRunning=true;doneReached=false;inflight=0;runToken++;setButtons();if(!isResume){processed=0;failed=0;excludedIds=[];excludedMap=Object.create(null);logLines=[];clearState();logText('开始处理队列（并发='+getConcurrency()+'）');}else{logText('继续处理队列（并发='+getConcurrency()+'）');}
updateStatus();saveState({isRunning:true,doneReached:false});schedule(runToken);}
function stopRun(){if(!isRunning)return;isRunning=false;runToken++;setButtons();updateStatus();logText('已停止');saveState({isRunning:false});}
function resetAllState(){if(isRunning){stopRun();}
isRunning=false;doneReached=false;inflight=0;runToken++;processed=0;failed=0;excludedIds=[];excludedMap=Object.create(null);logLines=[];clearState();renderLog();updateStatus();syncControlsVisibility();setButtons();}
function restoreFromState(){var st=loadState();if(!st)return false;processed=parseInt(st.processed,10)||0;failed=parseInt(st.failed,10)||0;doneReached=!!st.doneReached;excludedIds=Array.isArray(st.excludedIds)?st.excludedIds.slice(0,MAX_EXCLUDE):[];excludedMap=Object.create(null);for(var i=0;i<excludedIds.length;i++)excludedMap[excludedIds[i]]=1;logLines=Array.isArray(st.logLines)?st.logLines.slice(Math.max(0,st.logLines.length-LOG_LIMIT)):[];renderLog();updateStatus();return true;}
function init(){var start=$('wp-aiw-start');var resume=$('wp-aiw-resume');var stop=$('wp-aiw-stop');var clearBtn=$('wp-aiw-clear');restoreFromState();syncControlsVisibility();if(start){start.addEventListener('click',function(){startRun(false);});}
if(resume){resume.addEventListener('click',function(){restoreFromState();startRun(true);});}
if(stop){stop.addEventListener('click',function(){stopRun();});}
if(clearBtn){clearBtn.addEventListener('click',function(){var ok=true;try{ok=window.confirm('确定要清除 runner 的本地任务/日志并重置状态吗？');}catch(e){ok=true;}
if(!ok)return;resetAllState();setStatus('已清除任务与本地状态');var logEl=$('wp-aiw-log');if(logEl){logEl.innerHTML='<div class="wp-aiw-log-line">['+escapeHtml(formatTs())+'] '+escapeHtml('已清除任务与本地状态')+'</div>';}});}
setButtons();}
if(document.readyState==='loading'){document.addEventListener('DOMContentLoaded',init);}else{init();}})();